(function () { function initCarousel(root) { var track = root.querySelector(".aibui-carousel-track"); if (!track) return; var slides = root.querySelectorAll(".aibui-carousel-slide"); var dots = root.querySelectorAll(".aibui-carousel-dot"); var prev = root.querySelector(".aibui-carousel-prev"); var next = root.querySelector(".aibui-carousel-next"); var idx = 0; var autoplay = root.getAttribute("data-autoplay") === "1"; var delay = parseInt(root.getAttribute("data-delay") || "4", 10) * 1000; function getViewportWidth() { var holder = root.querySelector(".aibui-carousel-preview") || root; return holder.clientWidth || holder.offsetWidth || 0; } function update() { var w = getViewportWidth(); track.style.transform = "translateX(" + -idx * w + "px)"; dots.forEach(function (d, i) { d.classList.toggle("is-active", i === idx); }); } function go(n) { idx = (n + slides.length) % slides.length; update(); } if (prev) prev.addEventListener("click", function () { go(idx - 1); }); if (next) next.addEventListener("click", function () { go(idx + 1); }); var timer; function start() { if (autoplay && slides.length > 1) { stop(); timer = setInterval(function () { go(idx + 1); }, delay); } } function stop() { if (timer) { clearInterval(timer); timer = null; } } root.addEventListener("mouseenter", stop); root.addEventListener("mouseleave", start); dots.forEach(function (d, i) { d.addEventListener("click", function () { go(i); }); }); update(); start(); window.addEventListener("resize", update); } function boot() { var roots = document.querySelectorAll( ".wp-block-ai-builder-aibui-carousel" ); for (var i = 0; i < roots.length; i++) { initCarousel(roots[i]); } } if (document.readyState === "loading") { document.addEventListener("DOMContentLoaded", boot); } else { boot(); } })(); (function(){ function parseMarkers(root){ var el = root.querySelector('.aibui-map-markers'); if(!el) return []; try{ return JSON.parse(el.textContent || '[]') || []; }catch(e){ return []; } } function initOSM(root){ var ensure = function(cb){ if(window.L && window.L.map){ cb(); return; } var css = document.createElement('link'); css.rel = 'stylesheet'; css.href = 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.css'; document.head.appendChild(css); var s = document.createElement('script'); s.src = 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.js'; s.onload = cb; document.head.appendChild(s); }; ensure(function(){ var lat = parseFloat(root.getAttribute('data-center-lat')||'0'); var lng = parseFloat(root.getAttribute('data-center-lng')||'0'); var zoom = parseInt(root.getAttribute('data-zoom')||'12',10); var zoomCtl = root.getAttribute('data-zoom-control')==='1'; var draggable = root.getAttribute('data-draggable')==='1'; var canvas = root.querySelector('.aibui-map-canvas'); if(!canvas) return; var map = L.map(canvas, { zoomControl: zoomCtl, dragging: draggable }).setView([lat,lng], zoom); L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, attribution: '&copy; OpenStreetMap' }).addTo(map); var markers = parseMarkers(root); markers.forEach(function(m){ var marker = L.marker([parseFloat(m.lat)||0, parseFloat(m.lng)||0]).addTo(map); if(m.title){ marker.bindPopup(m.title); } }); }); } function initGoogle(root){ var apiKey = root.getAttribute('data-api-key')||''; var ensure = function(cb){ if(window.google && window.google.maps){ cb(); return; } var cbName = '__aibui_gmaps_cb_'+Math.random().toString(36).slice(2); window[cbName] = function(){ cb(); delete window[cbName]; }; var s = document.createElement('script'); var base = 'https://maps.googleapis.com/maps/api/js'; var qs = (apiKey ? ('key='+encodeURIComponent(apiKey)+'&') : '') + 'callback='+cbName; s.src = base + '?' + qs; s.async = true; s.defer = true; document.head.appendChild(s); }; ensure(function(){ var lat = parseFloat(root.getAttribute('data-center-lat')||'0'); var lng = parseFloat(root.getAttribute('data-center-lng')||'0'); var zoom = parseInt(root.getAttribute('data-zoom')||'12',10); var zoomCtl = root.getAttribute('data-zoom-control')==='1'; var draggable = root.getAttribute('data-draggable')==='1'; var canvas = root.querySelector('.aibui-map-canvas'); if(!canvas) return; var map = new google.maps.Map(canvas, { center:{lat:lat, lng:lng}, zoom: zoom, zoomControl: zoomCtl, draggable: draggable }); var markers = parseMarkers(root); markers.forEach(function(m){ var mk = new google.maps.Marker({ position: {lat: parseFloat(m.lat)||0, lng: parseFloat(m.lng)||0}, map: map, title: m.title||'' }); if(m.title){ var infowindow = new google.maps.InfoWindow({ content: m.title }); mk.addListener('click', function(){ infowindow.open({ anchor: mk, map }); }); } }); }); } function boot(){ var roots = document.querySelectorAll('.wp-block-ai-builder-aibui-map'); for(var i=0;i<roots.length;i++){ var r = roots[i]; var provider = r.getAttribute('data-provider')||'osm'; if(provider==='google') initGoogle(r); else initOSM(r); } } if(document.readyState==='loading'){ document.addEventListener('DOMContentLoaded', boot); }else{ boot(); } })(); (function () { function init(root) { var panels = root.querySelectorAll(".aibui-tab-panel"); if (!panels.length) return; var header = document.createElement("div"); header.className = "aibui-tabs-header"; var buttons = []; for (var i = 0; i < panels.length; i++) { var title = panels[i].getAttribute("data-title") || "Tab " + (i + 1); var btn = document.createElement("button"); btn.className = "aibui-tab-btn"; btn.textContent = title; header.appendChild(btn); buttons.push(btn); } root.insertBefore(header, root.firstChild); var panelsWrap = document.createElement("div"); panelsWrap.className = "aibui-tabs-panels"; for (var j = 0; j < panels.length; j++) { panelsWrap.appendChild(panels[j]); } root.appendChild(panelsWrap); var active = 0; var active = parseInt(root.getAttribute("data-active") || "0", 10) || 0; function activate(i) { for (var b = 0; b < buttons.length; b++) { buttons[b].classList.toggle("is-active", b === i); } for (var p = 0; p < panels.length; p++) { panels[p].classList.toggle("is-active", p === i); } root.setAttribute("data-active", i); } for (var i = 0; i < buttons.length; i++) { (function (idx) { buttons[idx].addEventListener("click", function () { activate(idx); }); })(i); } activate(Math.max(0, Math.min(active, panels.length - 1))); } function boot() { var roots = document.querySelectorAll(".wp-block-ai-builder-aibui-tabs"); for (var i = 0; i < roots.length; i++) { init(roots[i]); } } if (document.readyState === "loading") { document.addEventListener("DOMContentLoaded", boot); } else { boot(); } })(); (function () { function apply(tableRoot) { if (!tableRoot) return; var container = tableRoot.querySelector(".aibui-table-container") || tableRoot; var searchable = (container.getAttribute("data-searchable") || "0") === "1"; var sortable = (container.getAttribute("data-sortable") || "0") === "1"; var pageSize = parseInt(container.getAttribute("data-page-size") || "5", 10) || 5; var input = container.querySelector(".aibui-input"); var table = container.querySelector("table"); if (!table) return; var tbody = table.querySelector("tbody"); var headers = [].slice.call(table.querySelectorAll("thead th")); var rowEls = [].slice.call(tbody.querySelectorAll("tr")); var state = { q: "", sortIndex: -1, sortDir: 1, page: 1 }; function getRowValues(tr) { return [].slice.call(tr.children).map(function (td) { return (td.textContent || "").toLowerCase(); }); } var original = rowEls.map(function (tr) { return { el: tr, vals: getRowValues(tr) }; }); function render() { var filtered = original.filter(function (r) { if (!state.q) return true; return r.vals.some(function (v) { return v.indexOf(state.q) >= 0; }); }); if (sortable && state.sortIndex >= 0) { filtered.sort(function (a, b) { var av = a.vals[state.sortIndex] || ""; var bv = b.vals[state.sortIndex] || ""; if (av < bv) return -1 * state.sortDir; if (av > bv) return 1 * state.sortDir; return 0; }); } var total = filtered.length; var pages = Math.max(1, Math.ceil(total / pageSize)); if (state.page > pages) state.page = pages; var start = (state.page - 1) * pageSize, end = start + pageSize; original.forEach(function (r) { r.el.style.display = "none"; }); var pageRows = filtered.slice(start, end); var frag = document.createDocumentFragment(); pageRows.forEach(function (r) { r.el.style.display = ""; frag.appendChild(r.el); }); tbody.appendChild(frag); var ind = container.querySelector(".aibui-page-indicator"); if (ind) ind.textContent = state.page + " / " + pages; var prev = container.querySelector( ".aibui-table-pagination .aibui-btn:first-child" ); var next = container.querySelector( ".aibui-table-pagination .aibui-btn:last-child" ); if (prev) prev.disabled = state.page <= 1; if (next) next.disabled = state.page >= pages; } if (searchable && input) { input.addEventListener("input", function () { state.q = (input.value || "").toLowerCase(); state.page = 1; render(); }); } if (sortable) { headers.forEach(function (th, idx) { var btn = th.querySelector(".aibui-th-btn"); if (!btn) return; btn.addEventListener("click", function () { if (state.sortIndex === idx) { state.sortDir *= -1; } else { state.sortIndex = idx; state.sortDir = 1; } state.page = 1; headers.forEach(function (h) { h.removeAttribute("data-sort"); }); th.setAttribute("data-sort", state.sortDir === 1 ? "asc" : "desc"); render(); }); }); } var prev = container.querySelector( ".aibui-table-pagination .aibui-btn:first-child" ); var next = container.querySelector( ".aibui-table-pagination .aibui-btn:last-child" ); if (prev) prev.addEventListener("click", function () { if (state.page > 1) { state.page--; render(); } }); if (next) next.addEventListener("click", function () { state.page++; render(); }); render(); } function boot() { var blocks = document.querySelectorAll( ".wp-block-ai-builder-aibui-table, .aibui-table" ); for (var i = 0; i < blocks.length; i++) apply(blocks[i]); } if (document.readyState === "loading") document.addEventListener("DOMContentLoaded", boot); else boot(); })(); (function () { function createTip() { var tip = document.createElement("div"); tip.className = "aibui-stats-tip"; tip.style.position = "fixed"; tip.style.zIndex = "99999"; tip.style.pointerEvents = "none"; tip.style.padding = "6px 8px"; tip.style.border = "1px solid #e5e7eb"; tip.style.background = "#111827"; tip.style.color = "#fff"; tip.style.fontSize = "12px"; tip.style.borderRadius = "6px"; tip.style.boxShadow = "0 4px 14px rgba(0,0,0,.15)"; tip.style.transform = "translate(-50%, -120%)"; tip.style.whiteSpace = "nowrap"; tip.style.display = "none"; document.body.appendChild(tip); return tip; } var tipEl = createTip(); function showTip(text, x, y) { tipEl.textContent = text; tipEl.style.left = x + "px"; tipEl.style.top = y + "px"; tipEl.style.display = "block"; } function hideTip() { tipEl.style.display = "none"; } function attach(root) { root.addEventListener("pointerover", function (e) { var t = e.target; if (!(t instanceof Element)) return; var label = t.getAttribute("data-label"); var value = t.getAttribute("data-value"); if (value == null) return; var series = t.getAttribute("data-series") || ""; var parts = []; if (series) parts.push(series); if (label) parts.push(label); parts.push(value); var text = value; var rect = t.getBoundingClientRect(); showTip(text, rect.left + rect.width / 2, rect.top); }); root.addEventListener("pointermove", function (e) { if (tipEl.style.display === "none") return; showTip(tipEl.textContent, e.clientX, e.clientY - 10); }); root.addEventListener("pointerout", function (e) { hideTip(); }); } function boot() { var roots = document.querySelectorAll(".aibui-stats .aibui-stats-svg"); for (var i = 0; i < roots.length; i++) { attach(roots[i]); } } if (document.readyState === "loading") { document.addEventListener("DOMContentLoaded", boot); } else { boot(); } })(); document.addEventListener("DOMContentLoaded", function () { const snackbars = document.querySelectorAll(".aibui-snackbar-container"); snackbars.forEach((snackbar) => { const globalAutoClose = snackbar.getAttribute("data-global-auto-close") === "1"; const globalCloseDelay = parseInt(snackbar.getAttribute("data-global-close-delay")) || 5000; const buttonsData = JSON.parse( snackbar.getAttribute("data-buttons") || "[]" ); const actionButtons = snackbar.querySelectorAll( ".aibui-snackbar-action-btn" ); actionButtons.forEach((button, index) => { button.addEventListener("click", function (e) { const buttonData = buttonsData[index]; if (buttonData && buttonData.autoClose !== false) { closeSnackbar(snackbar); } }); }); if (globalAutoClose && globalCloseDelay > 0) { setTimeout(() => { if (snackbar.style.display !== "none") { closeSnackbar(snackbar); } }, globalCloseDelay); } }); function closeSnackbar(snackbar) { snackbar.classList.add("aibui-snackbar-closing"); setTimeout(() => { snackbar.style.display = "none"; snackbar.classList.remove("aibui-snackbar-closing"); }, 300); } document.addEventListener("click", function (e) { if (!e.target.closest(".aibui-snackbar-container")) { snackbars.forEach((snackbar) => { const globalAutoClose = snackbar.getAttribute("data-global-auto-close") === "1"; const globalCloseDelay = parseInt(snackbar.getAttribute("data-global-close-delay")) || 5000; if ( globalAutoClose && globalCloseDelay > 0 && snackbar.style.display !== "none" ) { closeSnackbar(snackbar); } }); } }); });